using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Input.Touch;
using Microsoft.Xna.Framework.Media;

namespace DrumPad
{
    /// <summary>
    /// To jest gwny typ dla naszej gry
    /// </summary>
    public class DrumpadGame : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;


        class soundPad
        {
            public Texture2D padTexture;
            public SoundEffect padSound;
            public Rectangle padRectangle;

            public soundPad(Texture2D inPadTexture, SoundEffect inPadSound, Rectangle inPadRectangle)
            {
                padTexture = inPadTexture;
                padSound = inPadSound;
                padRectangle = inPadRectangle;
            }

            public void Update(TouchCollection touches)
            {
                foreach (TouchLocation touch in touches)
                {
                    if (touch.State == TouchLocationState.Pressed)
                    {
                        if (padRectangle.Contains((int)touch.Position.X, (int)touch.Position.Y))
                        {
                            padSound.Play();
                        }
                    }
                }
            }

            public void Draw(SpriteBatch spriteBatch)
            {
                spriteBatch.Draw(padTexture, padRectangle, Color.White);
            }
        }

        // wiat gry

        // Parametry ekranu
        int displayWidth;
        int displayHeight;

        // Lista "przyciskw dwikowych"
        List<soundPad> pads = new List<soundPad>();

        public DrumpadGame()
        {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";

            graphics.PreferredBackBufferWidth = 240;
            graphics.PreferredBackBufferHeight = 400;

            // Domylna czstotliwo odwieania dla Windows Phone wynosi 30 fps.
            TargetElapsedTime = TimeSpan.FromTicks(333333);
        }

        /// <summary>
        /// Pozwala grze wykona dowoln inicjalizacj jakiej potrzebuje przed rozpoczeciem dziaania.
        /// To tutaj moe ona zada potrzebnych usug i zaadowa zwizan zawarto nie graficzn.
        /// Wywoanie base.Initialize wyliczy wszystkie komponenty i take je zainicjuje.
        /// </summary>
        protected override void Initialize()
        {
            displayWidth = GraphicsDevice.Viewport.Width;
            displayHeight = GraphicsDevice.Viewport.Height;

            base.Initialize();
        }

        /// <summary>
        /// LoadContent bedzie wywoany raz na gr i tu naley adowa
        /// ca zawarto.
        /// </summary>
        protected override void LoadContent()
        {
            // Stwrz nowy SpriteBatch, ktrego mona uzy do rysowania tekstur.
            spriteBatch = new SpriteBatch(GraphicsDevice);

            // Wczytaj nasze dwiki i tekstury i umie je na ekranie

            int halfWidth = displayWidth / 2;
            int halfHeight = displayHeight / 2;

            pads.Add(new soundPad(
                        Content.Load<Texture2D>("Images/cymbal"),
                        Content.Load<SoundEffect>("Sounds/cymbal"),
                        new Rectangle(0, 0, halfWidth, halfHeight))
                     );

            pads.Add(new soundPad(
                        Content.Load<Texture2D>("Images/top"),
                        Content.Load<SoundEffect>("Sounds/top"),
                        new Rectangle(halfWidth, 0, halfWidth, halfHeight))
                     );

            pads.Add(new soundPad(
                        Content.Load<Texture2D>("Images/snare"),
                        Content.Load<SoundEffect>("Sounds/snare"),
                        new Rectangle(0, halfHeight, halfWidth, halfHeight))
                     );

            pads.Add(new soundPad(
                        Content.Load<Texture2D>("Images/kick"),
                        Content.Load<SoundEffect>("Sounds/kick"),
                        new Rectangle(halfWidth, halfHeight, halfWidth, halfHeight))
                     );
        }

        /// <summary>
        /// UnloadContent bedzie wywoany raz na gr i tu naley usuwa 
        /// ca zawarto.
        /// </summary>
        protected override void UnloadContent()
        {
            // TODO: Usun w tym miejscu kad zawarto nie obsugiwan przez ContentManager
        }

        /// <summary>
        /// Pozwala uruchomi w grze logik, tak jak aktualizacja wiata,
        /// sprawdzenie kolizji, pobranie wejcia i odtwarzanie dwiku.
        /// </summary>
        /// <param name="gameTime">Dostarcza chwilow warto zmiennych czasowych.</param>
        protected override void Update(GameTime gameTime)
        {
            // Pozwala opusci gr
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed)
                this.Exit();

            TouchCollection touches = TouchPanel.GetState();

            foreach (soundPad s in pads)
            {
                s.Update(touches);
            }

            base.Update(gameTime);
        }

        /// <summary>
        /// Metoda wywoywana kiedy gra powinna si wyswietli.
        /// </summary>
        /// <param name="gameTime">Dostarcza chwilow warto zmiennych czasowych.</param>
        protected override void Draw(GameTime gameTime)
        {
            GraphicsDevice.Clear(Color.White);

            spriteBatch.Begin();

            foreach (soundPad s in pads)
            {
                s.Draw(spriteBatch);
            }

            spriteBatch.End();

            base.Draw(gameTime);
        }
    }
}
